


<?php $__env->startSection('content'); ?>



<div class="hero-container">
    <video autoplay muted loop playsinline class="hero-bg-video">
        <source src="Assets/72989-546335876_medium.mp4" type="video/mp4">
    </video>

    <div class="hero-text-area text-center" data-aos="fade-up">
        <h1 class="main-title">THE CITY <span class="dot">•</span> THE COAST <span class="dot">•</span> THE CONNECTION</h1>
        <p class="sub-title text-white">Discover the perfect blend of luxury, comfort, and convenience at Almaris</p>
        <div class="booking-wrapper" data-aos="fade-up" data-aos-delay="200">
      
        <div class="booking-bar">
            <div class="input-group">
                <label>Where</label>
                <input type="text" placeholder="Your Destination">
            </div>
            <div class="input-group">
    <label>Duration</label>
    <input type="text" id="date-range-picker" placeholder="Select Dates" select-range>
</div>
            <div class="input-group">
                <label>Guests & Rooms</label>
                <input type="text" value="2 Guests, 1 Room" readonly>
            </div>
            <button class="search-btn">Search</button>
        </div>
        
        <div class="booking-footer">
            <span>No credit card needed</span> • 
            <span>Free cancellation</span> • 
            <span>Booking stays safe</span>
        </div>
    </div>
    </div>

    
</div>

    <!-- 2nd Session Parallax -->
    <section class="about-section text-white">
        <div class="container text-center text-white py-5" data-aos="fade-up" data-aos-duration="1000">
            <p class="small text-uppercase letter-spacing-2 mb-5 text-white">Aathi Colombo - Where Bold Energy Meets Local Soul</p>
            
            <p class="fs-4 fw-light lh-lg mx-auto text-white" style="max-width: 900px;">
                Nestled in the heart of Colombo, Aathi is a serene escape with endless ocean views. Thoughtfully designed for both business and leisure, the hotel stands at the crossroads of heritage and modernity - where the old-world charm of Colombo flows into the bold skyline of Port City. Here, in Sri Lanka’s spirited heart, every stay offers a deeper connection to the island’s abundance, culture, and soul.
            </p>

            <div class="mt-5 pt-4">
                <svg width="60" height="30" viewBox="0 0 60 30" fill="none" stroke="rgba(255,255,255,0.6)" stroke-width="2" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 15 Q 7.5 5, 15 15 T 30 15 T 45 15 T 60 15" />
                    <path d="M0 7.5 Q 7.5 -2.5, 15 7.5 T 30 7.5 T 45 7.5 T 60 7.5" />
                    <path d="M0 22.5 Q 7.5 12.5, 15 22.5 T 30 22.5 T 45 22.5 T 60 22.5" />
                </svg>
            </div>
        </div>
    </section>

    <!-- 3rd Section: Features & Intro -->
    <section class="features-section container-fluid px-0">
        <div class="row g-0">
            <!-- Col 1: Facilities -->
            <div class="col-lg-3 col-md-6 feature-col" style="background-color: #1a1a1a;" data-aos="fade-right" data-aos-duration="1000">
                <div class="feature-card position-relative p-0 p-lg-5">
                    <!-- Adjusted padding on large screens to recreate the image inside dark background look -->
                    <img src="https://www.fourseasons.com/alt/img-opt/~75.701.150,0001-0,0000-2249,9999-3000,0000/publish/content/dam/fourseasons/images/web/HKG/HKG_4722_original.jpg" class="feature-img w-100 h-100 object-fit-cover"  alt="Rooftop Pool">
                    <div class="feature-text-overlay" style="padding-left:3.5rem; padding-bottom: 3.5rem;">
                        <h2 class="text-white text-uppercase letter-spacing-2 fs-4 mb-3 fw-light">Explore<br>Our<br>Facilities</h2>
                        <p class="text-white small mb-0 fw-light">Our facilities are thoughtfully<br>designed to enrich your stay.</p>
                    </div>
                </div>
            </div>
            
            <!-- Col 2: Dining -->
            <div class="col-lg-5 col-md-6 feature-col" data-aos="fade-up" data-aos-duration="1200" data-aos-delay="200">
                <div class="feature-card position-relative">
                    <img src="https://images.unsplash.com/photo-1517248135467-4c7edcad34c4?q=80&w=1200&auto=format&fit=crop" class="feature-img w-100 h-100 object-fit-cover" alt="Balcony Dining">
                    <div class="feature-text-overlay" style="padding-left: 4rem; padding-bottom: 3rem;">
                        <h2 class="text-white text-uppercase letter-spacing-2 fs-3 mb-4 fw-light">
                            <span class="bg-teal-highlight d-inline-block mb-1">Elevated</span><br>
                            <span class="bg-teal-highlight d-inline-block mb-1">Dining,</span><br>
                            <span class="bg-teal-highlight d-inline-block">Signature</span><br>
                            <span class="bg-teal-highlight d-inline-block">Flavours</span>
                        </h2>
                        <p class="text-white small mb-0 fw-light">Experience bold Sri Lankan<br>flavours, fused with signature<br>global creations.</p>
                    </div>
                </div>
            </div>
            
            <!-- Col 3: Intro -->
            <div class="col-lg-4 col-md-12 bg-white text-dark d-flex flex-column justify-content-center px-4 px-xl-5 py-5 feature-col" data-aos="fade-left" data-aos-duration="1000" data-aos-delay="400">
                <div class="ps-xl-4 pe-xl-5 py-4">
                     <h2 class="display-5 mb-3">Aathi Hotel</h2>
                  
                    <p class="small text-muted mb-4 pb-2" style="font-size: 0.8rem;">Colombo, Sri Lanka</p>
                    <div class="wavy-line-blue d-flex justify-content-center mb-3">
                   <i class="fa-solid fa-feather text-secondary display-6"></i>
                </div>
                    
                    <p class="text-secondary lh-lg mb-4 pb-2 fw-light" style="font-size: 0.9rem;">
                        Located along Marine Drive, steps from the Colpetty Railway Station, Aathi Colombo offers effortless access to the city, and a tranquil pause from it. Here, minimalist Japanese design blends with the textures of Sri Lankan living to create a refined retreat for every traveller.
                    </p>
                    <p class="text-secondary lh-lg mb-5 fw-light" style="font-size: 0.9rem;">
                        Every detail is crafted with intention, to spark connection, stir curiosity, and enrich your stay. From rooftop sundowners and signature Japanese cuisine, to interiors shaped by time-honoured local artisans, Aathi is a place where bold energy flows through every experience, inviting you to discover, connect, and unwind in your own rhythm.
                    </p>
                    
                    <div>
                        <a href="#" class="btn  text-uppercase letter-spacing-2 py-3 px-5 rounded-0 small fw-bold text-white custom-btn-outline" style="font-size: 0.8rem; background:#aa9a64;">More About Us</a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- WhatsApp Floating Icon -->
        <a href="https://wa.me/94112397397" class="whatsapp-float" target="_blank" aria-label="Chat on WhatsApp">
            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="currentColor" class="bi bi-whatsapp" viewBox="0 0 16 16">
              <path d="M13.601 2.326A7.85 7.85 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.9 7.9 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.9 7.9 0 0 0 13.6 2.326zM7.994 14.521a6.6 6.6 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.56 6.56 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592m3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.73.73 0 0 0-.529.247c-.182.198-.691.677-.691 1.654s.71 1.916.81 2.049c.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232"/>
            </svg>
        </a>
    </section>

    <!-- 4th Section: Our Accommodation Carousel -->
    <<?php echo $__env->make('layouts.inculdes.Accommodation-section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- 5th Section: Facilities Display -->
    <section class="facilities-section container-fluid px-0">
        <div class="row g-0">
            <!-- Col 1: Image Sub-Slider -->
            <div class="col-lg-6 facility-img-container" style="background-color: #1a1a1a;" data-aos="fade-right">
                <div class="swiper facilitiesSwiper w-100 h-100">
                    <div class="swiper-wrapper" id="facilitySwiperWrapper">
                        <!-- Populated dynamically by JS -->
                    </div>
                </div>
            </div>
            
            <!-- Col 2: Text Menu -->
            <div class="col-lg-6 d-flex flex-column justify-content-center py-5 px-4 px-md-5" data-aos="fade-left">
                <div class="text-center mb-5 mx-auto" style="max-width: 500px;">
                   
                     <h2 class="display-5 mb-3">Our Facilities</h2>
                        <div class="wavy-line-blue d-flex justify-content-center mb-3">
                   <i class="fa-solid fa-feather text-secondary display-6"></i>
                </div>
                    <p class="small  mb-3">Curated for Comfort & Convenience</p>
                    <p class="small text-muted fw-light lh-lg">Thoughtfully designed spaces for relaxation, wellness, and effortless convenience.</p>
                </div>

                <div class="mx-auto w-100" style="max-width: 500px;">
                    <ul class="facility-menu" id="facilityMenu">
                        <li class="facility-item active" data-index="0">Banquet Hall</li>
                        <li class="facility-item" data-index="1">Meeting Room</li>
                        <li class="facility-item" data-index="2">Infinity Pool & Jacuzzi</li>
                        <li class="facility-item" data-index="3">Sauna and Jacuzzi</li>
                        <li class="facility-item" data-index="4">Fitness Center</li>
                        <li class="facility-item" data-index="5">Lotus Lounge & Spa</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- 6th Section: Offers Carousel -->
    <section class="offers-section py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-4 fw-light mb-3 text-dark">Special Offers</h2>
                <div class="wavy-line-blue d-flex justify-content-center mb-3">
                   <i class="fa-solid fa-feather text-secondary display-6"></i>
                </div>
                <p class="small fw-bold">Exclusive Deals & Packages</p>
            </div>
            <div class="swiper offersSwiper">
                <div class="swiper-wrapper">
                    
                    <div class="swiper-slide">
                        <div class="offer-card">
                            <div class="offer-image-container">
                                <img src="https://mylomehotels.com/wp-content/uploads/2025/09/mylome_hotels_blog-768x512.png" alt="Honeymoon Offer" class="img-fluid">
                                <div class="offer-overlay">
                                    <h4>Honeymoon Offer</h4>
                                </div>
                            </div>
                            <div class="offer-footer-content">
                                <p>Join us for an unforgettable experience at our exclusive unlimited high tea buffet.</p>
                                <a href="#" class="explore-link">EXPLORE</a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="offer-card">
                            <div class="offer-image-container">
                                <img src="https://moihotels.com/wp-content/uploads/2025/02/7.webp" alt="Family Getaway" class="img-fluid">
                                <div class="offer-overlay">
                                    <h4>Family Getaway</h4>
                                </div>
                            </div>
                            <div class="offer-footer-content">
                                <p>Enjoy a memorable family getaway with our exclusive unlimited high tea buffet.</p>
                                <a href="#" class="explore-link">EXPLORE</a>
                            </div>  
                        </div> 
                    </div>


                     <div class="swiper-slide">
                        <div class="offer-card">
                            <div class="offer-image-container">
                                <img src="https://www.lemon8-app.com/seo/image?item_id=7553215671639818768&index=2&sign=18b98e15efb831a9db94df61fc4896d7" alt="Honeymoon Offer" class="img-fluid">
                                <div class="offer-overlay">
                                    <h4>High Tea</h4>
                                </div>
                            </div>
                            <div class="offer-footer-content">
                                <p>Join us for an unforgettable experience at our exclusive unlimited high tea buffet.</p>
                                <a href="#" class="explore-link">EXPLORE</a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="offer-card">
                            <div class="offer-image-container">
                                <img src="https://image-tc.galaxy.tf/wipng-aranzxi7aad88087d7plhu3yc/sushi-roll-website_standard.png?crop=0%2C0%2C1140%2C855" alt="Family Getaway" class="img-fluid">
                                <div class="offer-overlay">
                                    <h4>Japanese Buffet</h4>
                                </div>
                            </div>
                            <div class="offer-footer-content">
                                <p>Savour an exquisite spread at our signature Japanese buffet, held on the last week of every month.</p>
                                <a href="#" class="explore-link">EXPLORE</a>
                            </div>  
                        </div> 
                    </div>
                </div>
                <div class="swiper-pagination mt-3 position-relative bottom-0"></div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
    </section>

  
<section class="review-hero-section">
  <div class="review-overlay">
    <div class="review-container">
      
      <div class="review-content-wrapper">
        <span class="quote-icon">“</span>
        
        <div id="review-slider">
          <div class="review-slide active">
            <p class="review-text text-white">Experience unparalleled luxury and personalized service at Almaris Hotel, where every stay is a journey into sophistication, comfort, and unforgettable memories.</p>
            <h4 class="author">Donette Fondren</h4>
          </div>
          
          <div class="review-slide">
            <p class="review-text text-white">A breathtaking coastal retreat. The staff's attention to detail made our anniversary truly special and remarkably seamless.</p>
            <h4 class="author">Jonathan Reed</h4>
          </div>
          
          <div class="review-slide">
            <p class="review-text text-white">The perfect blend of modern amenities and natural beauty. I haven't slept this well in years. Highly recommended!</p>
            <h4 class="author">Sarah Jenkins</h4>
          </div>
        </div>

        <div class="review-dots">
          <span class="review-dot active" onclick="currentSlide(0)"></span>
          <span class="review-dot" onclick="currentSlide(1)"></span>
          <span class="review-dot" onclick="currentSlide(2)"></span>
        </div>
      </div>

      <div class="review-stats-container">
        <div class="review-stat-item">
          <h2>15000+</h2>
          <p class="text-white">Happy Customers</p>
        </div>
        <div class="review-stat-item">
          <h2>2500+</h2>
          <p class="text-white">Positive Reviews</p>
        </div>
        <div class="review-stat-item">
          <h2>25+</h2>
          <p class="text-white">Year of Experiences</p>
        </div>
      </div>

    </div>
  </div>
</section>

        <!-- 8th Session: Room List Card View -->
    <section class="room-list-section py-5 bg-white">
        <div class="container">
            <div class="text-center text-dark mb-5">
                <h2 class="display-5 fw-light mb-3">Hotel Area's</h2>
                <div class="wavy-line-blue d-flex justify-content-center mb-3">
                    <svg width="24" height="12" viewBox="0 0 24 12" fill="none" stroke="#4b8994" stroke-width="2" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 6 Q 3 2, 6 6 T 12 6 T 18 6 T 24 6" />
                    </svg>
                </div>
                <p class="small fw-bold">Explore Our Areas</p>
            </div>
            <div class="row g-4">
                <?php if($posts && count($posts) > 0): ?>
                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4" >
                        <div class="card bg-dark text-white border-0" >
                            <img src="<?php echo e($post->img); ?>" class="card-img" alt="<?php echo e($post->title); ?>" style="height: 250px; object-fit: cover;">
                            <div class="card-img-overlay d-flex flex-column justify-content-end" style="background:rgba(0,0,0,0.3);">
                                <h5 class="card-title"><?php echo e($post->title); ?></h5>
                                <p class="card-text text-white"><?php echo e($post->content); ?></p>   
                     </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                <?php else: ?>
                    <p>Not Available Rooms</p>
                <?php endif; ?>
                
            </div>
        </div>
    </section>



 <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.Master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laravel\aathi_Hotel\resources\views/layouts/index.blade.php ENDPATH**/ ?>