<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Granbell Hotel UI</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@200;300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    
      <!-- AOS CSS -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="<?php echo e(url('style.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">

</head>
<style>
    /* Ensure the picker stays within the viewport on small screens */
.flatpickr-calendar {
    max-width: 300px !important;
}

@media (max-width: 768px) {
    .flatpickr-calendar.open {
        left: 50% !important;
        transform: translateX(-50%) !important;
        top: 100px !important; /* Adjust based on your hero height */
    }
}
</style>
<body>

  
<?php echo $__env->make('layouts.inculdes.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
<?php echo $__env->yieldContent('content'); ?>

<?php echo $__env->make('layouts.inculdes.instragram-gallery', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.inculdes.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 

    <!-- Review Popup -->
    <div class="review-popup" id="reviewPopup">
        <div class="review-content text-center">
            <div class="review-header d-flex justify-content-between align-items-center">
                <p>review</p>
                <button class="review-close border-0" id="reviewToggle"><i class="fas fa-chevron-up"></i></button>
            </div>
            
            <h6>4.3/5</h6>
            <p>"Excellent"</p>
            <span>13194 reviews</span>
            <div class="review-details">
                <button class="btn btn-sm btn-outline-secondary mt-2" onclick="document.getElementById('reviewPopup').style.display='none';">Close</button>
                <p class="mt-3">"The location is perfect, right by the beach. Highly recommend!"</p>
                <span>- vijayakumar sanjeevan</span>
                <p>"Excellent breakfast and friendly staff. Will definitely come back."</p>
                <span>- sivaloganathan vinuja</span>
            </div>
        </div>
    </div>

    <div class="menu-overlay" id="fullMenu">
        <button class="close-overlay" id="closeMenu">&times;</button>
        
        <div class="container h-100 d-flex align-items-center">
            <div class="row w-100">
                <div class="col-lg-4 d-none d-lg-block border-end border-white border-opacity-25 py-5">
                    <div class="contact-block mb-5">
                           <img src="Assets/logo-aathi.png" alt="Logo" height="200">
                        <h6>Aathi Hotel</h6>
                        <p  class="text-white">282/5, Kollupitiya Road,<br>Marine Drive, Colombo 3, Sri Lanka.</p>
                    </div>
                    <div class="contact-block mb-5 ">
                        <h6>Hotline</h6>
                        <p class="text-white">+94 112 397 397</p>
                    </div>
                    <div class="contact-block">
                        <h6>Email</h6>
                        <p class="text-white">reservations@aathihotel.lk</p>
                    </div>
                </div>

                <div class="col-lg-8 text-center text-lg-start ps-lg-5">
                    <ul class="overlay-nav-links">
                        <li><a href="#">Home</a></li>
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Accommodation</a></li>
                        <li><a href="#">Dining</a></li>
                        <li><a href="#">Facilities</a></li>
                        <li><a href="#">Offers</a></li>
                        <li><a href="#">Contact Us</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>





<script>
document.addEventListener("DOMContentLoaded", () => {
  const slides = document.querySelectorAll('.review-slide');
  const dots = document.querySelectorAll('.review-dot');
  let currentIdx = 0;
  const slideInterval = 5000; // 5 seconds

  function showSlide(index) {
    // Reset all slides and dots
    slides.forEach(slide => slide.classList.remove('active'));
    dots.forEach(dot => dot.classList.remove('active'));

    // Activate the specific slide and dot
    slides[index].classList.add('active');
    dots[index].classList.add('active');
  }

  function nextSlide() {
    currentIdx = (currentIdx + 1) % slides.length;
    showSlide(currentIdx);
  }

  // Handle manual dot clicks
  window.currentSlide = (index) => {
    currentIdx = index;
    showSlide(currentIdx);
    resetTimer(); // Optional: restart timer on click
  };

  // Set the 5s timer
  let autoSlide = setInterval(nextSlide, slideInterval);

  function resetTimer() {
    clearInterval(autoSlide);
    autoSlide = setInterval(nextSlide, slideInterval);
  }
});
</script>















<script>
    flatpickr("#date-range-picker", {
    mode: "range",            // Enables From & To selection
    minDate: "today",         // Prevents booking in the past
    dateFormat: "d M",        // e.g., "20 Mar"
    showMonths: 2,            // Shows two months at once on desktop
    
    // Mobile optimization:
    onReady: function(selectedDates, dateStr, instance) {
        if (window.innerWidth < 768) {
            instance.set("showMonths", 1); // Only 1 month on mobile screens
        }
    },
    
    // Customizing the output format once selected
    onClose: function(selectedDates, dateStr, instance) {
        if (selectedDates.length === 2) {
            const start = selectedDates[0];
            const end = selectedDates[1];
            const diffTime = Math.abs(end - start);
            const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
            
            // Updates input to: "20 Mar - 24 Mar (4 Nights)"
            instance.input.value = `${instance.formatDate(start, "d M")} - ${instance.formatDate(end, "d M")} (${diffDays} Nights)`;
        }
    }
});
</script>
    <script>
        const menuToggle = document.getElementById('menuToggle');
const closeMenu = document.getElementById('closeMenu');
const fullMenu = document.getElementById('fullMenu');

// Open Menu
menuToggle.addEventListener('click', () => {
    fullMenu.classList.add('active');
});

// Close Menu
closeMenu.addEventListener('click', () => {
    fullMenu.classList.remove('active');
});

// Close on 'Esc' key
document.addEventListener('keydown', (e) => {
    if (e.key === "Escape") fullMenu.classList.remove('active');
});




window.addEventListener('scroll', function() {
    const navbar = document.querySelector('.navbar');
    // window.innerHeight / 2 represents 50vh
    if (window.scrollY > (window.innerHeight / 2)) {
        navbar.classList.add('scrolled');
    } else {
        navbar.classList.remove('scrolled');
    }
});
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- AOS Animation JS -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    <script>
        // Initialize AOS
        AOS.init({
            once: true, // whether animation should happen only once - while scrolling down
            offset: 100, // offset (in px) from the original trigger point
        });

        // Initialize Swiper
        var swiper = new Swiper(".accommodationSwiper", {
            slidesPerView: 1,
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 5000, // 5s auto sliding
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
            breakpoints: {
                // when window width is >= 768px
                768: {
                    slidesPerView: 2,
                    spaceBetween: 20
                },
                // when window width is >= 1024px
                1024: {
                    slidesPerView: 3,
                    spaceBetween: 30
                }
            }
        });

        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.fixed-navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
                navbar.classList.remove('border-opacity-10');
            } else {
                navbar.classList.remove('scrolled');
                navbar.classList.add('border-opacity-10');
            }
        });

        // 5th Section Interactive slider logic
        const facilitiesData = [
            { title: "BANQUET HALL", subtitle: "Weddings, Conferences and More", img: "https://images.unsplash.com/photo-1519167758481-83f550bb49b3?q=80&w=1200&auto=format&fit=crop" },
            { title: "MEETING ROOM", subtitle: "Corporate Gatherings in Style", img: "https://images.unsplash.com/photo-1497366216548-37526070297c?q=80&w=1200&auto=format&fit=crop" },
            { title: "INFINITY POOL & JACUZZI", subtitle: "Endless Ocean Views", img: "https://images.unsplash.com/photo-1576013551627-0cc20b96c2a7?q=80&w=1200&auto=format&fit=crop" },
            { title: "SAUNA AND JACUZZI", subtitle: "Relaxation and Therapy", img: "https://images.unsplash.com/photo-1515362778563-6a8d0e44bc0b?q=80&w=1200&auto=format&fit=crop" },
            { title: "FITNESS CENTER", subtitle: "Stay Active During Your Stay", img: "https://images.unsplash.com/photo-1534438327276-14e5300c3a48?q=80&w=1200&auto=format&fit=crop" },
            { title: "LOTUS LOUNGE & SPA", subtitle: "Rejuvenate Your Senses", img: "https://granbellhotel.lk/wp-content/uploads/2025/04/Spa-1200x630-1.jpg" }
        ];

        const swiperWrapper = document.getElementById('facilitySwiperWrapper');
        const facilityMenuItems = document.querySelectorAll('.facility-item');

        // Populate Swiper perfectly to act as sliding cards
        facilitiesData.forEach(fac => {
            const slide = document.createElement('div');
            slide.className = 'swiper-slide w-100 h-100 position-relative';
            slide.innerHTML = `
                <img src="${fac.img}" class="facility-main-img w-100 h-100 object-fit-cover" alt="${fac.title}">
                <div class="facility-img-overlay">
                    <h4 class="text-uppercase letter-spacing-1 fw-light fs-4 mb-2">${fac.title}</h4>
                    <div class="wavy-line-white mb-2 d-flex justify-content-center">
                        <svg width="24" height="12" viewBox="0 0 24 12" fill="none" stroke="#fff" stroke-width="1.5" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 6 Q 3 2, 6 6 T 12 6 T 18 6 T 24 6" />
                        </svg>
                    </div>
                    <p class="small fw-light mb-3 text-white">${fac.subtitle}</p>
                    <button class="btn-explore">EXPLORE</button>
                </div>
            `;
            swiperWrapper.appendChild(slide);
        });

        // Initialize Swiper (creates genuine auto-sliding cards functionality!)
        const facilitiesSwiper = new Swiper('.facilitiesSwiper', {
            loop: true,
            effect: 'slide',
            speed: 600,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            on: {
                slideChange: function () {
                    // This runs every time the swiper auto slides (every 5s)
                    let index = this.realIndex;
                    facilityMenuItems.forEach(item => item.classList.remove('active'));
                    const activeItem = document.querySelector(`.facility-item[data-index="${index}"]`);
                    if (activeItem) activeItem.classList.add('active');
                }
            }
        });

        // Add robust click events to menu items
        facilityMenuItems.forEach(item => {
            item.addEventListener('click', (e) => {
                const index = parseInt(e.target.getAttribute('data-index'));
                
                // Instruct Swiper to slide directly to that card smoothly
                facilitiesSwiper.slideToLoop(index);
                
                // Mobile responsive scroll to image when tapped
                if (window.innerWidth < 992) {
                    const imgContainer = document.querySelector('.facility-img-container');
                    const offsetPosition = imgContainer.getBoundingClientRect().top + window.scrollY - 70; // 70px offset for the fixed navbar
                    window.scrollTo({
                         top: offsetPosition,
                         behavior: "smooth"
                    });
                }
            });
        });
    </script>

    <!-- Offers Swiper -->
    <script>
        const offersSwiper = new Swiper('.offersSwiper', {
            slidesPerView: 1,
            spaceBetween: 30,
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                }
            }
        });
    </script>

    <!-- Footer Swiper -->
    <script>
        const footerSwiper = new Swiper('.footerSwiper', {
            slidesPerView: 1,
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            effect: 'fade',
            fadeEffect: {
                crossFade: true
            }
        });
    </script>

    <!-- Gallery Swiper -->
    <script>
        const gallerySwiper = new Swiper('.gallerySwiper', {
            slidesPerView: 1,
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            breakpoints: {
                768: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: 5,
                    spaceBetween: 20,
                }
            }
        });
    </script>

    <!-- Gallery Modal and Review Popup Scripts -->
    <script>
        function openGalleryModal(imageSrc) {
            document.getElementById('modalImage').src = imageSrc;
            const modal = new bootstrap.Modal(document.getElementById('galleryModal'));
            modal.show();
        }

        // Show review popup after 5 seconds
        setTimeout(() => {
            document.getElementById('reviewPopup').style.display = 'block';
        }, 5000);

        // Toggle review popup expand/collapse
        document.getElementById('reviewToggle').addEventListener('click', () => {
            const popup = document.getElementById('reviewPopup');
            const icon = document.querySelector('#reviewToggle i');
            if (popup.classList.contains('expanded')) {
                popup.classList.remove('expanded');
                icon.className = 'fas fa-chevron-up';
            } else {
                popup.classList.add('expanded');
                icon.className = 'fas fa-chevron-down';
            }
        });
    </script>

    <!-- Booking Modal -->
    <div class="modal fade" id="bookingModal" tabindex="-1" aria-labelledby="bookingModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content dark-theme">
                <div class="modal-header">
                    <h5 class="modal-title fw-light letter-spacing-1" id="bookingModalLabel">Book Your Stay</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="checkIn" class="form-label small text-uppercase letter-spacing-1">Check In</label>
                                <input type="date" class="form-control" id="checkIn">
                            </div>
                            <div class="col-md-6">
                                <label for="checkOut" class="form-label small text-uppercase letter-spacing-1">Check Out</label>
                                <input type="date" class="form-control" id="checkOut">
                            </div>
                            <div class="col-md-4">
                                <label for="adults" class="form-label small text-uppercase letter-spacing-1">Adults</label>
                                <select class="form-select" id="adults">
                                    <option value="1">1</option>
                                    <option value="2" selected>2</option>
                                    <option value="3">3</option>
                                    <option value="4">4+</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="children" class="form-label small text-uppercase letter-spacing-1">Children</label>
                                <select class="form-select" id="children">
                                    <option value="0" selected>0</option>
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3+</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="nationality" class="form-label small text-uppercase letter-spacing-1">Nationality</label>
                                <select class="form-select" id="nationality">
                                    <option value="local">Local</option>
                                    <option value="foreign">Foreign</option>
                                </select>
                            </div>
                            <div class="col-12 mt-4">
                                <label for="couponCode" class="form-label small text-uppercase letter-spacing-1">Have a Coupon code?</label>
                                <input type="text" class="form-control" id="couponCode" placeholder="Enter code here">
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary text-uppercase small letter-spacing-1" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary-teal text-uppercase small letter-spacing-1 px-4">Book Now</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Gallery Modal -->
    <div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="galleryModalLabel">Gallery Image</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <img id="modalImage" src="" alt="Gallery Image" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
</body>
</html><?php /**PATH E:\laravel\aathi_Hotel\resources\views/layouts/Master.blade.php ENDPATH**/ ?>