
<!-- 4th Section: Our Accommodation Carousel -->
    <section class="accommodation-section">
        <div class="container-fluid px-0">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="display-5 mb-3">Our Accommodation</h2>
                    <div class="wavy-line-blue d-flex justify-content-center mb-3">
                   <i class="fa-solid fa-feather text-secondary display-6"></i>
                </div>
                <p class="small fw-bold mb-4 pb-2">Relax in Comfort</p>
                <a href="#" class="text-decoration-none text-dark small text-uppercase letter-spacing-2 fw-bold" style="border-bottom: 1px solid #4b8994; padding-bottom: 5px;">VIEW ALL ACCOMMODATION</a>
            </div>

            <!-- Swiper -->
            <div class="swiper accommodationSwiper mt-5 pt-3" data-aos="fade-up" data-aos-delay="200">
                <div class="swiper-wrapper">
                     <?php if($Accommodation_posts && count($Accommodation_posts) > 0): ?>
                    <?php $__currentLoopData = $Accommodation_posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Slide 1 -->
                    <div class="swiper-slide">
                        <div class="room-card mx-2">
                            <img src="<?php echo e($post->img); ?>" class="room-img" alt="<?php echo e($post->title); ?>">
                            <div class="room-card-overlay">
                                <h4 class="text-uppercase letter-spacing-1 fw-light fs-5 mb-2"><?php echo e($post->title); ?></h4>
                                <div class="wavy-line-white mb-2">
                                     <svg width="24" height="12" viewBox="0 0 24 12" fill="none" stroke="#fff" stroke-width="1.5" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M0 6 Q 3 2, 6 6 T 12 6 T 18 6 T 24 6" />
                                    </svg>
                                </div>
                                <p class="small fw-light text-white mb-3"><?php echo e($post->content); ?></p>
                                <button class="btn-explore">EXPLORE</button>
                            </div>
                        </div>
                    </div>

                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                <?php else: ?>
                    <p>Not Available Rooms</p>
                <?php endif; ?>
                   
                </div>
                <!-- Add Pagination & Navigation -->
                <div class="swiper-pagination  mt-3  position-relative bottom-0"></div>
                <div class="swiper-button-next d-none d-md-flex"></div>
                <div class="swiper-button-prev d-none d-md-flex"></div>
            </div>
        </div>
    </section><?php /**PATH E:\laravel\aathi_Hotel\resources\views/layouts/inculdes/Accommodation-section.blade.php ENDPATH**/ ?>