@extends('layouts.Master')

@section('content')
<div class="hero-container" style="height: 60vh;">
    <img src="https://www.miraggio.gr/media/ftoibfcf/miraggio-thermal-spa-resort-halkidiki-1_deluxe-side-sea-view.jpg" class="hero-bg-image" style="z-index:0;">
    <div class="hero-overlay" style="z-index:1;"></div>
    
</div>
<nav class="breadcrumb text-dark">
        <h6>Home</h6>
        <span class="dot"></span>
        <h6 class="active fw-bold">Rooms</h6>
    </nav>

    <hr class="top-divider">

  <section class="content-wrapper text-dark">
        <header>
            <h1 >Bold Stays in the Spirited Heart of Colombo</h1>
            <h6 class="subtitle">Discover Granbell Hotel Colombo</h6>
            <div class="wave-icon">
                <svg width="40" height="10" viewBox="0 0 40 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 5C5 5 5 1 10 1C15 1 15 5 20 5C25 5 25 9 30 9C35 9 35 5 40 5" stroke="#79B8D1" stroke-width="1.5"/>
                </svg>
            </div>
        </header>

     
    </section>



<section class="room-section mt-5">

    <div class="room-wrapper">


 <!-- RIGHT CONTENT SIDE -->
        <div class="room-content text-dark">
            <h1>Effortless Comfort in a Thoughtfully Designed Space</h1>
            <div class="line"></div>

            <p>
               Escape the chaos, embrace the calm! Step into a deluxe haven where Japanese minimalism meets pure indulgence. With a private terrace, a luxurious sea-view bathtub, and panoramic Indian Ocean vistas, this is more than just a stay it’s an experience.
            </p>

             <p>
Whether you’re unwinding in a deep soak or soaking in the sunset, this is Colombo’s ultimate beachfront retreat! Recognised among the premier beach view hotels in Colombo, Granbell Hotel offers an unparalleled blend of luxury and serenity.

            <div class="buttons">
                <a href="#" class="btn-explore">EXPLORE</a>
                <a href="#" class="btn-check">CHECK AVAILABILITY</a>
            </div>
        </div>



        <!-- LEFT IMAGE SIDE -->
        <div class="room-image">
            <img src="{{ url('https://www.miraggio.gr/media/ftoibfcf/miraggio-thermal-spa-resort-halkidiki-1_deluxe-side-sea-view.jpg') }}" alt="Standard Room">
            
            
          
        </div>

       
    </div>

</section>


<section class="room-container">
        <div class="image-section">
            <img src="https://www.alescoproperty.com/wp-content/uploads/2023/09/visualsofdana-T5pL6ciEn-I-unsplash.jpg" alt="Hotel Room View">
        </div>

        <div class="content-section">
            <header>
                <h1>Room Features and Amenities</h1>
                <p class="subtitle">Thoughtfully Curated for Your Stay</p>
                <div class="wave-icon">~~</div>
                <p class="description">
                    Explore a selection of thoughtfully curated features and modern amenities for a comfortable, seamless stay.
                </p>
            </header>

            <div class="main-features">
                <div class="feature-item">
                    <div class="icon">☀️</div>
                    <div class="text">
                        <h3>Sea View</h3>
                        <p>Experience breathtaking views of the Indian Ocean from the comfort of your room.</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="icon">🪟</div>
                    <div class="text">
                        <h3>Private Terrace</h3>
                        <p>Step outside and unwind in your own open-air space, perfect for relaxing while enjoying fresh air and scenic views.</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="icon">🛁</div>
                    <div class="text">
                        <h3>Scenic View Bath</h3>
                        <p>Unwind in a luxurious bath with uninterrupted views of the ocean.</p>
                    </div>
                </div>
            </div>

            <ul class="amenities-list">
                <li>Bath and Shower Toiletries</li>
                <li>Complimentary Wi-Fi</li>
                <li>Electric Kettle</li>
                <li>En-suite Bathroom</li>
                <li>King Size / Twin Bed</li>
                <li>Safe Box</li>
                <li>Satellite TV</li>
                <li>Sea View</li>
                <li>Tea and Coffee Making Facilities</li>
                <li>Terrace</li>
            </ul>
        </div>
    </section>






@endsection