@extends('layouts.Master')

@section('content')
<div class="hero-container" style="height: 60vh;">
    <img src="https://www.grecotel.com/therocclub/wp-content/uploads/sites/16/2024/08/01-club-deluxe-room-the-roc-club.jpg" class="hero-bg-image" style="z-index:0;">
    <div class="hero-overlay" style="z-index:1;"></div>
    
</div>
<nav class="breadcrumb text-dark">
        <h6>Home</h6>
        <span class="dot"></span>
        <h6 class="active fw-bold">Accommodation</h6>
    </nav>


    <hr class="top-divider">

    <section class="content-wrapper text-dark">
        <header>
            <h1 >Accommodation at Granbell</h1>
            <p class="subtitle">Where Design Meets Comfort, and Every Detail Matters</p>
            <div class="wave-icon">
                <svg width="40" height="10" viewBox="0 0 40 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 5C5 5 5 1 10 1C15 1 15 5 20 5C25 5 25 9 30 9C35 9 35 5 40 5" stroke="#79B8D1" stroke-width="1.5"/>
                </svg>
            </div>
        </header>

        <article class="description">
            <p>
                At Granbell Colombo, each room is thoughtfully designed to reflect our blend of minimalist Japanese 
                aesthetics and handcrafted Sri Lankan detail. Whether you're here to recharge, work, or simply take in 
                the views, our rooms are curated to offer comfort, character, and bold inspiration.
            </p>
            <p>
                Choose from ocean-facing or city-view rooms - all offering intuitive amenities, crafted interiors, and a 
                bold sense of place that mirrors the energy of Colombo outside your window.
            </p>
        </article>
    </section>


<section class="room-section mt-5">

    <div class="room-wrapper">

        <!-- LEFT IMAGE SIDE -->
        <div class="room-image">
            <img src="{{ url('https://manor-design.com/wp-content/uploads/2022/09/boutique-hotel-bedroom-1.jpg') }}" alt="Standard Room">
            
            <!-- Bottom Feature Bar -->
            <div class="room-features">
                <div class="feature-item">
                    <i class="bi bi-arrows-fullscreen"></i>
                    <div>
                        <h6>Spacious Living</h6>
                        <p>Room Size – 27.54 m2 / 296.43 ft2</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-person"></i>
                    <div>
                        <h6>Perfect For</h6>
                        <p>2 Adults</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-bed"></i>
                    <div>
                        <h6>Bed Room</h6>
                        <p>1 Queen Bed / Twin Bed</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT CONTENT SIDE -->
        <div class="room-content text-dark">
            <h1>Standard Room</h1>
            <div class="line"></div>

            <p>
                Our Standard Room is designed to make your stay in Colombo both 
                comfortable and convenient. With contemporary interiors and 
                amenities, it offers a cosy retreat in the heart of the city.
            </p>

            <div class="buttons">
                <a href="#" class="btn-explore">EXPLORE</a>
                <a href="#" class="btn-check">CHECK AVAILABILITY</a>
            </div>
        </div>

    </div>

</section>


<section class="room-section mt-5">

    <div class="room-wrapper">


 <!-- RIGHT CONTENT SIDE -->
        <div class="room-content text-dark">
            <h1>Superior Room + View Bath</h1>
            <div class="line"></div>

            <p>
               The Superior Room with View Bath offers uninterrupted Indian Ocean views from both the bedroom and bathroom. Elegantly designed, it blends modern comfort with breathtaking scenery for a truly relaxing stay.
            </p>

            <div class="buttons">
                <a href="#" class="btn-explore">EXPLORE</a>
                <a href="#" class="btn-check">CHECK AVAILABILITY</a>
            </div>
        </div>



        <!-- LEFT IMAGE SIDE -->
        <div class="room-image">
            <img src="{{ url('https://www.pradoresort.com/wp-content/uploads/2022/09/prado_luxury_hotel_room_sea_view-scaled.jpg') }}" alt="Standard Room">
            
            <!-- Bottom Feature Bar -->
            <div class="room-features">
                <div class="feature-item">
                    <i class="bi bi-arrows-fullscreen"></i>
                    <div>
                        <h6>Spacious Living</h6>
                        <p>Room Size – 27.54 m2 / 296.43 ft2</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-person"></i>
                    <div>
                        <h6>Perfect For</h6>
                        <p>2 Adults</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-bed"></i>
                    <div>
                        <h6>Bed Room</h6>
                        <p>1 Queen Bed / Twin Bed</p>
                    </div>
                </div>
            </div>
        </div>

       
    </div>

</section>

<section class="room-section mt-5">

    <div class="room-wrapper">

        <!-- LEFT IMAGE SIDE -->
        <div class="room-image">
            <img src="{{ url('https://assets.tivolihotels.com/image/upload/q_auto,f_auto,c_limit,w_1045/media/minor/tivoli/images/hotels/tcar/rooms/deluxe-terrace-room/rspt_nh_tivoli-carvoeiro_145_950x550.jpg') }}" alt="Standard Room">
            
            <!-- Bottom Feature Bar -->
            <div class="room-features">
                <div class="feature-item">
                    <i class="bi bi-arrows-fullscreen"></i>
                    <div>
                        <h6>Spacious Living</h6>
                        <p>Room Size – 27.54 m2 / 296.43 ft2</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-person"></i>
                    <div>
                        <h6>Perfect For</h6>
                        <p>2 Adults</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-bed"></i>
                    <div>
                        <h6>Bed Room</h6>
                        <p>1 Queen Bed / Twin Bed</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT CONTENT SIDE -->
        <div class="room-content text-dark">
            <h1>Superior Room + Terrace</h1>
            <div class="line"></div>

            <p>
                Designed for a relaxing stay, our Superior Room with terrace provide modern comforts and essential amenities, ensuring a memorable experience.
            </p>

            <div class="buttons">
                <a href="#" class="btn-explore">EXPLORE</a>
                <a href="#" class="btn-check">CHECK AVAILABILITY</a>
            </div>
        </div>

    </div>

</section>


<section class="room-section mt-5">

    <div class="room-wrapper">


 <!-- RIGHT CONTENT SIDE -->
        <div class="room-content text-dark">
            <h1>Deluxe Room + Sea View With Bath And Terrace</h1>
            <div class="line"></div>

            <p>
                ​Looking for a peaceful escape in the heart of Colombo? Our Deluxe Rooms + Sea View With Bath and Terrace at Granbell Hotel Colombo offer just that. Designed with your comfort in mind, these elegant spaces provide a serene retreat from the city's hustle and bustle.
            </p>

            <div class="buttons">
                <a href="#" class="btn-explore">EXPLORE</a>
                <a href="#" class="btn-check">CHECK AVAILABILITY</a>
            </div>
        </div>



        <!-- LEFT IMAGE SIDE -->
        <div class="room-image">
            <img src="{{ url('https://www.miraggio.gr/media/ftoibfcf/miraggio-thermal-spa-resort-halkidiki-1_deluxe-side-sea-view.jpg') }}" alt="Standard Room">
            
            <!-- Bottom Feature Bar -->
            <div class="room-features">
                <div class="feature-item">
                    <i class="bi bi-arrows-fullscreen"></i>
                    <div>
                        <h6>Spacious Living</h6>
                        <p>Room Size – 27.54 m2 / 296.43 ft2</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-person"></i>
                    <div>
                        <h6>Perfect For</h6>
                        <p>2 Adults</p>
                    </div>
                </div>

                <div class="feature-item">
                    <i class="bi bi-bed"></i>
                    <div>
                        <h6>Bed Room</h6>
                        <p>1 Queen Bed / Twin Bed</p>
                    </div>
                </div>
            </div>
        </div>

       
    </div>

</section>





@include('layouts.inculdes.Accommodation-section')
@endsection